/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    './src/**/*.{js,ts,jsx,tsx,mdx}',
    './node_modules/tailwind-datepicker-react/dist/**/*.js'
  ],
  safelist: [
    {
      pattern: /grid-cols-[1-6]+/,
      variants: ['lg', 'sm', 'md', 'xl']
    }
  ],
  darkMode: ['class', '[data-theme="dark"]'],
  theme: {
    extend: {
      zIndex: {
        1: 1
      }
    },
    screens: {
      sm: '640px',
      // => @media (min-width: 640px) { ... }

      md: '768px',
      // => @media (min-width: 768px) { ... }

      lg: '1024px',
      // => @media (min-width: 1024px) { ... }

      xl: '1280px',
      // => @media (min-width: 1280px) { ... }

      '2xl': '1536px',
      '3xl': '2600px',
      '4xl': '4000px'
    }
  },
  plugins: []
};
