import * as yup from 'yup';

export const validateUsername = (message = 'Username is required') => yup.string().min(3, 'Username must be at least 3 characters').matches(/^\S*$/, 'Whitespace is not allowed').matches(/^[a-zA-Z0-9]+$/, 'Special Characters are not allowed')
  .required(message);
export const validateName = () => yup.string().min(3).matches(/^\S*$/, 'Whitespace is not allowed').optional();
export const validatePassword = (message = 'Password is required') => yup.string().min(8).matches(/^\S*$/, 'Whitespace is not allowed').required(message);
export const validateEmail = (message = 'Enter a valid email') => yup
  .string()
  .email(message)
  .matches(
    // eslint-disable-next-line no-useless-escape
    /^[\w-\.]+@([\w-]+\.)+[\w-]{1,4}$/,
    { message }
  )
  .required('Email is required!');
