import {
  IVideo, PageableData, Res, VideoUpload
} from 'src/interfaces';
import { catchError } from '@lib/utils';
import { APIRequest } from './api-request';

export class VideoService extends APIRequest {
  public async search(query = {}, headers = {}): Promise<Res<PageableData<IVideo>>> {
    return this.get(this.buildUrl('/videos/search', query), headers, { next: { tags: ['search', 'video'] }, cache: 'no-store' }).catch(catchError);
  }

  public async getUploadedVideo(query = {}, headers = {}): Promise<Res<PageableData<IVideo>>> {
    return this.get(this.buildUrl('/videos/uploaded', query), headers, { cache: 'no-store' }).catch(catchError);
  }

  public async findOne(id: string, headers = {}): Promise<Res<IVideo>> {
    return this.get(`/videos/${id}/view`, headers, { cache: 'no-store' }).catch(catchError);
  }

  public async uploadMainVideo(file: File, onProgress?: ({ percentage }: {percentage: number}) => void) {
    return this.upload({
      url: '/videos/main/sign-upload-url',
      file,
      onProgress
    });
  }

  public create(payload: VideoUpload) {
    return this.post('/videos', payload);
  }

  public update(id: string, payload: VideoUpload) {
    return this.put(`/videos/${id}`, payload);
  }

  public remove(id: string) {
    return this.del(`/videos/${id}`);
  }

  public addView(id: string) {
    return this.post(`/videos/add-view/${id}`);
  }

  public addShares(id: string) {
    return this.post(`/videos/add-share/${id}`);
  }

  public download(id: string) {
    return this.post(`/videos/download/${id}`);
  }
}

export const videoService = new VideoService();
