import { Res } from 'src/interfaces';
import type { PublicSettings } from '@lib/utils';

import { catchError } from '@lib/utils';
import { APIRequest } from './api-request';

export class SettingService extends APIRequest {
  all(group = ''): Promise<Res<PublicSettings>> {
    return this.get(this.buildUrl('/settings/public', { group }), {}, { next: { tags: ['search', 'setting'] } }).catch(catchError);
  }

  valueByKeys(keys: string[]): Promise<Res<any>> {
    return this.post('/settings/keys', { keys }, {}, { next: { tags: ['search', 'setting'] } }).catch(catchError);
  }
}

export const settingService = new SettingService();
