import { APIRequest } from './api-request';

export class ProfileService extends APIRequest {
  getMe(token?: string) {
    const headers = token ? {
      Authorization: token
    } : undefined;
    return this.get('/profiles/me', headers, { cache: 'no-store' });
  }

  update(data: any) {
    return this.put('/profiles', data);
  }

  uploadAvatar(file: File, onProgress = () => {}) {
    return this.upload({
      type: 'avatar',
      file,
      url: '/profiles/avatar/upload-url',
      onProgress
    });
  }

  getProfileDocs(profileId: any) {
    return this.post('/profiles/documents', profileId);
  }
}

export const profileService = new ProfileService();
