import { IPost, PageableData, Res } from 'src/interfaces';
import { catchError } from '@lib/utils';
import { APIRequest } from './api-request';

export class PostService extends APIRequest {
  public async search(query = {}, headers = {}): Promise<Res<PageableData<IPost>>> {
    return this.get(this.buildUrl('/posts/search', query), headers, { next: { tags: ['search', 'post'] } }).catch(catchError);
  }

  public async getMenus(query = {}, headers = {}): Promise<any> {
    return this.get(this.buildUrl('/menus', query), headers, { next: { tags: ['search', 'post'] } }).catch(catchError);
  }

  public async findOne(id: string, headers = {}): Promise<Res<IPost>> {
    return this.get(`/posts/${id}`, headers, { next: { tags: ['search', 'post', id] } }).catch(catchError);
  }
}

export const postService = new PostService();
