import { ICategory, PageableData, Res } from 'src/interfaces';
import { catchError } from '@lib/utils';
import { APIRequest } from './api-request';

export class CategoryService extends APIRequest {
  public async search(query = {}, headers = {}): Promise<Res<PageableData<ICategory>>> {
    return this.get(this.buildUrl('/categories/search', query), headers, { next: { tags: ['search', 'category'] } }).catch(catchError);
  }

  public async findOne(id: string, headers = {}): Promise<Res<ICategory>> {
    return this.get(`/categories/${id}/view`, headers, { cache: 'no-store' }).catch(catchError);
  }
}

export const categoryService = new CategoryService();
