import cookie from 'js-cookie';
import { signOut } from 'next-auth/react';
import { catchError } from '@lib/utils';
import { APIRequest } from './api-request';
import { IRegister, IUpdatePassword, Res } from '../interfaces';

export class AuthService extends APIRequest {
  async login(payload: any): Promise<{ token: string }> {
    const { data } = await this.post('/auth/login', payload);
    cookie.set('token', data.token);
    return data;
  }

  register(payload: IRegister) {
    return this.post('/auth/register', payload);
  }

  getToken() {
    return cookie.get('token');
  }

  clearToken() {
    cookie.remove('token');
  }

  setToken(token: string) {
    cookie.set('token', token);
  }

  changePassword(payload: IUpdatePassword) {
    return this.put('/auth/change-password', payload);
  }

  forgotPassword(payload: any) {
    return this.post('/auth/forgot', payload);
  }

  verifyPasswordFromToken(token: string): Promise<Res<any>> {
    return this.post('/auth/forgot/verify', { token }).catch(catchError);
  }

  changePasswordFromToken(payload: any) {
    return this.post('/auth/forgot/change-password', payload);
  }

  async signOut() {
    this.clearToken();
    await this.get(this.buildUrl(`${window.location.origin}/api/revalidate`, { tag: 'auth' }));
    signOut();
  }
}

export const authService = new AuthService();
