import { Ads, PageableData, Res } from 'src/interfaces';
import { catchError } from '@lib/utils';
import { APIRequest } from './api-request';

export class AdsService extends APIRequest {
  public async search(query = {}, headers = {}): Promise<Res<PageableData<Ads>>> {
    return this.get(this.buildUrl('/ads/search', query), headers, { next: { tags: ['search', 'ads'] } }).catch(catchError);
  }
}

export const adsService = new AdsService();
