import { getToken } from 'next-auth/jwt';
import { i18nRouter } from 'next-i18n-router';
import { NextRequest, NextResponse } from 'next/server';

import { i18nConfig } from './i18n-config';

export default async function middleware(req: NextRequest) {
  const path = req.nextUrl.pathname;

  const session = await getToken({
    req,
    secret: process.env.NEXTAUTH_SECRET
  });

  if (!session && path.includes('/account')) {
    return NextResponse.redirect(new URL('/', req.url));
  }

  const res = await fetch(`${process.env.API_ENDPOINT}/settings/keys`, {
    method: 'POST',
    body: JSON.stringify({ keys: ['defaultLocale'] }),
    cache: 'no-store',
    headers: {
      'Content-Type': 'application/json'
    }
  }).then((resp) => resp.json());

  return i18nRouter(req, { ...i18nConfig, localeDetector: false, defaultLocale: res?.data?.defaultLocale || 'en' } as any);
}

export const config = {
  // Matcher ignoring `/_next/` and `/api/`
  matcher: ['/((?!api|_next/static|_next/image|favicon.ico|images).*)']
};
