export const defaultSettings = {
  siteName: 'xStreamer',
  logoUrl: '/images/logo-white.png',
  favicon: '',
  homeTitle: 'Home',
  homeMetaKeywords: '',
  homMetaDescription: '',
  headerScript: '',
  afterBodyScript: '',
  htmlMetaTags: '',
  gaCode: '',
  siteCopyright: '@xStreamer',
  signupPlaceholderImage: null,
  defaultThumbnailImage: null,
  defaultLocale: 'en',
  enableMultiLanguage: true,
  gtmId: null,
  enableMaintenanceMode: false,
  footerContent: '',
  hideTitle: true,
  hideLikes: true,
  hideViews: true,
  hideFavorite: true
};

export type PublicSettings = typeof defaultSettings;

export function getResponseError(data: any): string {
  if (!data) {
    return '';
  }
  if (typeof data === 'string') {
    return data;
  }
  // TODO - parse for language or others
  if (typeof data.message === 'string' || typeof data.msg === 'string') return data.message || data.msg;

  if (Array.isArray(data.message)) {
    const item = data.message[0];
    if (!item.constraints) {
      return item || data.error || 'An error occurred, please try again!';
    }
    return Object.values(item.constraints)[0] as string;
  }

  return 'An error occurred, please try again!';
}

export async function catchError(error: any) {
  const e = await Promise.resolve(error);
  return {
    error: getResponseError(e)
  };
}

export const formatNumber = (num: number): string => {
  const units = ['', 'K', 'M', 'B', 'T'];
  let unitIndex = 0;

  while (num >= 1000 && unitIndex < units.length - 1) {
    // eslint-disable-next-line no-param-reassign
    num /= 1000;
    unitIndex += 1;
  }

  const formattedNum = num >= 10 ? Math.floor(num) : parseFloat(num.toFixed(1));

  return `${formattedNum}${units[unitIndex]}`;
};

export const angle = () => {
  // iOS
  if (typeof window.orientation === 'number') {
    return window.orientation;
  }
  // Android
  if (typeof window !== 'undefined' && window.screen && window.screen.orientation && window.screen.orientation.angle) {
    return window.orientation;
  }
  return 0;
};
