export const checkImageBeforeUpload = (file: File, sizeLimit = 20) => {
  const isJpgOrPng = file.type === 'image/jpeg' || file.type === 'image/png';
  if (!isJpgOrPng) {
    throw new Error('You can only upload JPG/PNG file!');
  }
  const isLt2M = file.size / 1024 / 1024 < sizeLimit;
  if (!isLt2M) {
    throw new Error(`Image must smaller than ${sizeLimit}MB!`);
  }
  return isJpgOrPng && isLt2M;
};

export const getBase64 = (img: File, callback: (url: string) => void) => {
  const reader = new FileReader();
  reader.addEventListener('load', () => callback(reader.result as string));
  reader.readAsDataURL(img);
};
