import moment from 'moment';
import { isNaN } from 'lodash';

export function formatDate(date: Date, format = 'DD/MM/YYYY HH:mm:ss') {
  return moment(date).format(format);
}

export function formatDateNoTime(date: Date, format = 'DD MMM YYYY') {
  return moment(date).format(format);
}

export function formatDuration(s: any): string {
  let duration = 0;

  if (typeof s === 'string') {
    const parsed = Number(s);
    if (!isNaN(parsed)) {
      duration = parsed;
    }
  } else if (typeof s === 'number') {
    duration = s;
  }

  if (!duration || duration < 0) return '00:00';

  const hours = Math.floor(duration / 3600);
  const minutes = Math.floor((duration % 3600) / 60);
  const seconds = Math.floor(duration % 60);

  const format = (num: number) => (num < 10 ? `0${num}` : `${num}`);

  return hours > 0
    ? `${format(hours)}:${format(minutes)}:${format(seconds)}`
    : `${format(minutes)}:${format(seconds)}`;
}
