// eslint-disable-next-line import/no-cycle
import { ICategory, IPornstar } from '.';
import { SearchParams } from './utils';

export interface IVideoStats {
  likes: number;
  views: number;
  favourites: number;
  dislikes: number;
  shares: number;
  comments: number;
}

export interface IVideo {
  _id: string;
  description: string;
  title: string;
  duration: number;
  hd: boolean;
  price: number;
  thumbnails: string[];
  slug: string;
  embeddedCode: string;
  video: any;
  tags: string[];
  isLiked: boolean;
  isDisLiked: boolean;
  isBookmarked: boolean;
  performers: IPornstar[];
  categories: ICategory[];
  stats: IVideoStats;
  played: boolean;
  createdAt: Date;
  isHD: boolean;
  convertStatus: string;
  categoryIds: string[];
  verified: boolean;
  seoTitle: string;
  seoDesc: string;
  seoKeywords: string;
}

export interface VideoSearch extends SearchParams {
  categoryIds: string;
  tags: string;
  performerIds: string;
}

export interface VideoUpload {
  title: string;
  description: string;
  fileId: string;
  tags: string[];
  categoryIds: string[];
}
