export interface ISearch {
  q: string;
  limit: number;
  page: number;
  offset: number;
  sort: string;
  sortBy: string;
}

export interface SearchParams extends ISearch {
  status: string;
  excludeId: string;
}

export interface PageableData<T> {
  data: T[];
  total: number;
}

export interface IResponse<T> {
  status: number;
  data: T;
}

export interface Res<T = any> extends Partial<IResponse<T>> {
  error?: any;
  message?: string;
  success?: boolean;
  statusCode?: number;
}

export interface ICountry {
  name: string;
  code: string;
  flag: string;
}

export interface ILangguges {
  name: string;
  code: string;
}

export interface IPhoneCodes {
  name: string;
  code: string;
  dialCode: string;
}

export interface IListResponse<T> {
  data: T[];
  total: number;
}

export interface ActionState<T = any> {
  error?: any;
  message?: string;
  data?: T | undefined;
  success?: boolean;
}
