export interface IFileUpload {
  /**
   * url to get file upload URL
   */
  url: string;

  /**
   * file binary data
   */
  file: File;
  /**
   * type of file eg avatar, feed-photo...
   */
  type?: string;
  /**
   * field name for file upload. Default is `file`
   */
  fieldName?: string;

  /**
   * post data when calling get file upload url
   */
  body?: any;

  /**
   * callback function for upload
   */
  onProgress?: Function;
}

export type FileList = {
  id: string | number;
  url?: string;
  status?: string;
  name: string;
  file: File;
}[];
