export const LOCALES = [
  { code: 'ab', name: 'Abkhaz', key: 'ab' },
  { code: 'aa', name: 'Afar', key: 'aa' },
  { code: 'af', name: 'Afrikaans', key: 'af' },
  { code: 'ak', name: 'Akan', key: 'ak' },
  { code: 'sq', name: 'Albanian', key: 'sq' },
  { code: 'am', name: 'Amharic', key: 'am' },
  { code: 'ar', name: 'Arabic', key: 'ar' },
  { code: 'an', name: 'Aragonese', key: 'an' },
  { code: 'hy', name: 'Armenian', key: 'hy' },
  { code: 'as', name: 'Assamese', key: 'as' },
  { code: 'av', name: 'Avaric', key: 'av' },
  { code: 'ae', name: 'Avestan', key: 'ae' },
  { code: 'ay', name: 'Aymara', key: 'ay' },
  { code: 'az', name: 'Azerbaijani', key: 'az' },
  { code: 'bm', name: 'Bambara', key: 'bm' },
  { code: 'ba', name: 'Bashkir', key: 'ba' },
  { code: 'eu', name: 'Basque', key: 'eu' },
  { code: 'be', name: 'Belarusian', key: 'be' },
  { code: 'bn', name: 'Bengali', key: 'bn' },
  { code: 'bh', name: 'Bihari', key: 'bh' },
  { code: 'bi', name: 'Bislama', key: 'bi' },
  { code: 'bs', name: 'Bosnian', key: 'bs' },
  { code: 'br', name: 'Breton', key: 'br' },
  { code: 'bg', name: 'Bulgarian', key: 'bg' },
  { code: 'my', name: 'Burmese', key: 'my' },
  { code: 'ca', name: 'Catalan; Valencian', key: 'ca' },
  { code: 'ch', name: 'Chamorro', key: 'ch' },
  { code: 'ce', name: 'Chechen', key: 'ce' },
  { code: 'ny', name: 'Chichewa; Chewa; Nyanja', key: 'ny' },
  { code: 'zh', name: 'Chinese', key: 'zh' },
  { code: 'cv', name: 'Chuvash', key: 'cv' },
  { code: 'kw', name: 'Cornish', key: 'kw' },
  { code: 'co', name: 'Corsican', key: 'co' },
  { code: 'cr', name: 'Cree', key: 'cr' },
  { code: 'hr', name: 'Croatian', key: 'hr' },
  { code: 'cs', name: 'Czech', key: 'cs' },
  { code: 'da', name: 'Danish', key: 'da' },
  { code: 'dv', name: 'Divehi; Dhivehi; Maldivian;', key: 'dv' },
  { code: 'nl', name: 'Dutch', key: 'nl' },
  {
    code: 'en', name: 'English', key: 'en', default: true
  },
  { code: 'eo', name: 'Esperanto', key: 'eo' },
  { code: 'et', name: 'Estonian', key: 'et' },
  { code: 'ee', name: 'Ewe', key: 'ee' },
  { code: 'fo', name: 'Faroese', key: 'fo' },
  { code: 'fj', name: 'Fijian', key: 'fj' },
  { code: 'fi', name: 'Finnish', key: 'fi' },
  { code: 'fr', name: 'French', key: 'fr' },
  { code: 'ff', name: 'Fula; Fulah; Pulaar; Pular', key: 'ff' },
  { code: 'gl', name: 'Galician', key: 'gl' },
  { code: 'ka', name: 'Georgian', key: 'ka' },
  { code: 'de', name: 'German', key: 'de' },
  { code: 'el', name: 'Greek, Modern', key: 'el' },
  { code: 'gn', name: 'Guaraní', key: 'gn' },
  { code: 'gu', name: 'Gujarati', key: 'gu' },
  { code: 'ht', name: 'Haitian; Haitian Creole', key: 'ht' },
  { code: 'ha', name: 'Hausa', key: 'ha' },
  { code: 'he', name: 'Hebrew (modern)', key: 'he' },
  { code: 'hz', name: 'Herero', key: 'hz' },
  { code: 'hi', name: 'Hindi', key: 'hi' },
  { code: 'ho', name: 'Hiri Motu', key: 'ho' },
  { code: 'hu', name: 'Hungarian', key: 'hu' },
  { code: 'ia', name: 'Interlingua', key: 'ia' },
  { code: 'id', name: 'Indonesian', key: 'id' },
  { code: 'ie', name: 'Interlingue', key: 'ie' },
  { code: 'ga', name: 'Irish', key: 'ga' },
  { code: 'ig', name: 'Igbo', key: 'ig' },
  { code: 'ik', name: 'Inupiaq', key: 'ik' },
  { code: 'io', name: 'Ido', key: 'io' },
  { code: 'is', name: 'Icelandic', key: 'is' },
  { code: 'it', name: 'Italian', key: 'it' },
  { code: 'iu', name: 'Inuktitut', key: 'iu' },
  { code: 'ja', name: 'Japanese', key: 'ja' },
  { code: 'jv', name: 'Javanese', key: 'jv' },
  { code: 'kl', name: 'Kalaallisut, Greenlandic', key: 'kl' },
  { code: 'kn', name: 'Kannada', key: 'kn' },
  { code: 'kr', name: 'Kanuri', key: 'kr' },
  { code: 'ks', name: 'Kashmiri', key: 'ks' },
  { code: 'kk', name: 'Kazakh', key: 'kk' },
  { code: 'km', name: 'Khmer', key: 'km' },
  { code: 'ki', name: 'Kikuyu, Gikuyu', key: 'ki' },
  { code: 'rw', name: 'Kinyarwanda', key: 'rw' },
  { code: 'ky', name: 'Kirghiz, Kyrgyz', key: 'ky' },
  { code: 'kv', name: 'Komi', key: 'kv' },
  { code: 'kg', name: 'Kongo', key: 'kg' },
  { code: 'ko', name: 'Korean', key: 'ko' },
  { code: 'ku', name: 'Kurdish', key: 'ku' },
  { code: 'kj', name: 'Kwanyama, Kuanyama', key: 'kj' },
  { code: 'la', name: 'Latin', key: 'la' },
  { code: 'lb', name: 'Luxembourgish, Letzeburgesch', key: 'lb' },
  { code: 'lg', name: 'Luganda', key: 'lg' },
  { code: 'li', name: 'Limburgish, Limburgan, Limburger', key: 'li' },
  { code: 'ln', name: 'Lingala', key: 'ln' },
  { code: 'lo', name: 'Lao', key: 'lo' },
  { code: 'lt', name: 'Lithuanian', key: 'lt' },
  { code: 'lu', name: 'Luba-Katanga', key: 'lu' },
  { code: 'lv', name: 'Latvian', key: 'lv' },
  { code: 'gv', name: 'Manx', key: 'gv' },
  { code: 'mk', name: 'Macedonian', key: 'mk' },
  { code: 'mg', name: 'Malagasy', key: 'mg' },
  { code: 'ms', name: 'Malay', key: 'ms' },
  { code: 'ml', name: 'Malayalam', key: 'ml' },
  { code: 'mt', name: 'Maltese', key: 'mt' },
  { code: 'mi', name: 'Māori', key: 'mi' },
  { code: 'mr', name: 'Marathi (Marāṭhī)', key: 'mr' },
  { code: 'mh', name: 'Marshallese', key: 'mh' },
  { code: 'mn', name: 'Mongolian', key: 'mn' },
  { code: 'na', name: 'Nauru', key: 'na' },
  { code: 'nv', name: 'Navajo, Navaho', key: 'nv' },
  { code: 'nd', name: 'North Ndebele', key: 'nd' },
  { code: 'ne', name: 'Nepali', key: 'ne' },
  { code: 'ng', name: 'Ndonga', key: 'ng' },
  { code: 'nb', name: 'Norwegian Bokmål', key: 'nb' },
  { code: 'nn', name: 'Norwegian Nynorsk', key: 'nn' },
  { code: 'no', name: 'Norwegian', key: 'no' },
  { code: 'ii', name: 'Nuosu', key: 'ii' },
  { code: 'nr', name: 'South Ndebele', key: 'nr' },
  { code: 'oc', name: 'Occitan', key: 'oc' },
  { code: 'oj', name: 'Ojibwe, Ojibwa', key: 'oj' },
  {
    code: 'cu',
    name: 'Old Church Slavonic, Church Slavic, Church Slavonic, Old Bulgarian, Old Slavonic',
    key: 'cu'
  },
  { code: 'om', name: 'Oromo', key: 'om' },
  { code: 'or', name: 'Oriya', key: 'or' },
  { code: 'os', name: 'Ossetian, Ossetic', key: 'os' },
  { code: 'pa', name: 'Panjabi, Punjabi', key: 'pa' },
  { code: 'pi', name: 'Pāli', key: 'pi' },
  { code: 'fa', name: 'Persian', key: 'fa' },
  { code: 'pl', name: 'Polish', key: 'pl' },
  { code: 'ps', name: 'Pashto, Pushto', key: 'ps' },
  { code: 'pt', name: 'Portuguese', key: 'pt' },
  { code: 'qu', name: 'Quechua', key: 'qu' },
  { code: 'rm', name: 'Romansh', key: 'rm' },
  { code: 'rn', name: 'Kirundi', key: 'rn' },
  { code: 'ro', name: 'Romanian, Moldavian, Moldovan', key: 'ro' },
  { code: 'ru', name: 'Russian', key: 'ru' },
  { code: 'sa', name: 'Sanskrit (Saṁskṛta)', key: 'sa' },
  { code: 'sc', name: 'Sardinian', key: 'sc' },
  { code: 'sd', name: 'Sindhi', key: 'sd' },
  { code: 'se', name: 'Northern Sami', key: 'se' },
  { code: 'sm', name: 'Samoan', key: 'sm' },
  { code: 'sg', name: 'Sango', key: 'sg' },
  { code: 'sr', name: 'Serbian', key: 'sr' },
  { code: 'gd', name: 'Scottish Gaelic; Gaelic', key: 'gd' },
  { code: 'sn', name: 'Shona', key: 'sn' },
  { code: 'si', name: 'Sinhala, Sinhalese', key: 'si' },
  { code: 'sk', name: 'Slovak', key: 'sk' },
  { code: 'sl', name: 'Slovene', key: 'sl' },
  { code: 'so', name: 'Somali', key: 'so' },
  { code: 'st', name: 'Southern Sotho', key: 'st' },
  { code: 'es', name: 'Spanish; Castilian', key: 'es' },
  { code: 'su', name: 'Sundanese', key: 'su' },
  { code: 'sw', name: 'Swahili', key: 'sw' },
  { code: 'ss', name: 'Swati', key: 'ss' },
  { code: 'sv', name: 'Swedish', key: 'sv' },
  { code: 'ta', name: 'Tamil', key: 'ta' },
  { code: 'te', name: 'Telugu', key: 'te' },
  { code: 'tg', name: 'Tajik', key: 'tg' },
  { code: 'th', name: 'Thai', key: 'th' },
  { code: 'ti', name: 'Tigrinya', key: 'ti' },
  { code: 'bo', name: 'Tibetan Standard, Tibetan, Central', key: 'bo' },
  { code: 'tk', name: 'Turkmen', key: 'tk' },
  { code: 'tl', name: 'Tagalog', key: 'tl' },
  { code: 'tn', name: 'Tswana', key: 'tn' },
  { code: 'to', name: 'Tonga (Tonga Islands)', key: 'to' },
  { code: 'tr', name: 'Turkish', key: 'tr' },
  { code: 'ts', name: 'Tsonga', key: 'ts' },
  { code: 'tt', name: 'Tatar', key: 'tt' },
  { code: 'tw', name: 'Twi', key: 'tw' },
  { code: 'ty', name: 'Tahitian', key: 'ty' },
  { code: 'ug', name: 'Uighur, Uyghur', key: 'ug' },
  { code: 'uk', name: 'Ukrainian', key: 'uk' },
  { code: 'ur', name: 'Urdu', key: 'ur' },
  { code: 'uz', name: 'Uzbek', key: 'uz' },
  { code: 've', name: 'Venda', key: 've' },
  { code: 'vi', name: 'Vietnamese', key: 'vi' },
  { code: 'vo', name: 'Volapük', key: 'vo' },
  { code: 'wa', name: 'Walloon', key: 'wa' },
  { code: 'cy', name: 'Welsh', key: 'cy' },
  { code: 'wo', name: 'Wolof', key: 'wo' },
  { code: 'xh', name: 'Xhosa', key: 'xh' },
  { code: 'yi', name: 'Yiddish', key: 'yi' },
  { code: 'yo', name: 'Yoruba', key: 'yo' },
  { code: 'za', name: 'Zhuang, Chuang', key: 'za' },
  { code: 'zu', name: 'Zulu', key: 'zu' },
  { code: 'cn', name: 'China', key: 'cn' }
];

export const i18nConfig = {
  defaultLocale: 'en',
  // locales: ['en', 'fr', 'ch', 'pl', 'pt', 'es', 'de', 'cn'],
  locales: LOCALES.map((locale) => locale.code),
  ns: ['main'],
  localeDetector: false
};

export type Locale = (typeof i18nConfig)['locales'][number];

export default i18nConfig;
