'use client';

import { IVideoStats } from 'src/interfaces';
import { CalendarIcon, EyeIcon } from '@heroicons/react/24/solid';
import { formatDate } from '@lib/date';
import { formatNumber } from '@lib/utils';
import { useMemo } from 'react';
import { useVideoPlayer } from './video-player-provider';

export function VideoViewStat() {
  const {
    video: { stats = {} as IVideoStats, createdAt }
  } = useVideoPlayer();

  const randomViews = useMemo(() => {
    const random = Math.random() * 9 + 1;
    return `${random.toFixed(1)}k`;
  }, []);

  return (
    <div className="mr-2 sm:ml-auto space-x-3 flex items-center">
      {/* {settings.videoEnableViewCount && ( */}
      <div className="inline-flex items-center text-sm font-normal text-neutral-200">
        <EyeIcon width={20} height={20} className="me-1" style={{ color: 'var(--icon-color)' }} />
        <span>
          {randomViews}
        </span>
      </div>
      {/* )} */}
      <div className="inline-flex items-center text-sm font-normal text-neutral-200">
        <CalendarIcon width={20} height={20} className="me-1" style={{ color: 'var(--icon-color)' }} />
        <span>{formatDate(createdAt, 'DD/MM/YYYY')}</span>
      </div>
    </div>
  );
}
