import { videoService } from '@services/video.service';
import { VideoSearch as VideoSearchAd } from 'src/interfaces';
import { Pagination } from '@components/ui/base';
import VideoGrid from './video-grid';

interface Props extends Partial<VideoSearchAd> {
  span?: {
    xs?: number;
    md?: number;
    sm?: number;
    lg?: number;
    xl?: number;
  },
  className?: string;
  showTotal?: boolean;
}

export default async function VideoSearch({
  showTotal = false, limit = 10, page = 1, className = '', span = {
    xs: 2, sm: 2, md: 3, lg: 4, xl: 5
  }, ...params
}: Props) {
  const offset = (page - 1) * limit;
  const { error, data } = await videoService.search({ limit, offset, ...params });
  if (error) return null;
  if (!data!.data.length) return null;

  return (
    <>
      {showTotal && (
      <h3 className="mb-5 font-bold">
        {data!.total}
        {' '}
        Videos
      </h3>
      )}
      <VideoGrid videos={data!.data} className={className} span={span} />
      <Pagination pageSize={limit} query={{ limit, ...params }} page={page} total={data!.total} />
    </>
  );
}
