'use client';

import classNames from 'classnames';
import { IVideo, PublicSettings } from 'src/interfaces';
import dynamic from 'next/dynamic';
import Loader from '@components/ui/base/loader';
import s from './video-player.module.scss';
import VideoPlayerProvider from './video-player-provider';
import { VideoViewStat } from './video-stats';

const VideoPlayerScreen = dynamic(() => import('./video-player-screen'), {
  ssr: false,
  loading: () => <Loader spinning center />
});

interface Props {
  video: IVideo;
  embedPlayer: boolean;
  settings?: Partial<PublicSettings>;
}

export function VideoPlayer({ video, embedPlayer = false, ...props }: Props) {
  if (!video) return null;

  return (
    <VideoPlayerProvider video={video} embedPlayer={embedPlayer} {...props}>
      <div
        className={classNames(
          s.videoPlayer,
          'w-full rounded-md overflow-hidden',
          { [s.embedPlayer]: embedPlayer }
        )}
      >
        <div className="pt-[55%] relative max-h-[680px]">
          <VideoPlayerScreen />
        </div>
      </div>
      <div
        className={classNames(
          s['button-player'],
          'flex items-center px-2.5 py-2.5 bg-grey flex-wrap sm:justify-normal justify-center'
        )}
      />
      <VideoViewStat />
    </VideoPlayerProvider>
  );
}
