'use client';

import CategoriesGrid from '@components/categories/categories-grid';
import { PageHeader } from '@components/layout/page-header';
import PornstarGrid from '@components/pornstar/pornstar-grid';
import { useState } from 'react';
import { IVideo } from 'src/interfaces';
import { ChevronDownIcon, ChevronUpIcon } from '@heroicons/react/24/solid';

interface Props {
  video: IVideo;
}

export default function VideoPlayerInformation({ video }: Props) {
  const [toggle, setToggle] = useState(false);

  if (!video) return null;

  return (
    <>
      <div hidden={!toggle} className="space-y-5">
        <p className="text-sm whitespace-pre-wrap break-words">{video.description}</p>
        <div>
          <PageHeader title="Categories" />
          <CategoriesGrid
            span={{ xs: 2, md: 3, lg: 4 }}
            categories={video.categories}
          />
        </div>
        <div>
          <PageHeader title="Pornstars" />
          <PornstarGrid
            span={{ xs: 2, md: 3, lg: 4 }}
            pornstars={video.performers}
          />
        </div>
      </div>
      <div
        onKeyDown={(e) => {
          if (e.key === 'Enter' || e.key === ' ') {
            setToggle(!toggle);
          }
        }}
        tabIndex={0}
        role="button"
        className="text-center border cursor-pointer border-neutral-500 text-neutral-300 rounded-md p-1 w-full hover:text-primary hover:border-primary"
        onClick={() => setToggle(!toggle)}
      >
        <div>
          {toggle ? (
            <>
              <span className="text-sm">Show less</span>
              <ChevronUpIcon className="inline" width={16} height={16} />
            </>
          ) : (
            <>
              <span className="text-sm">Show more</span>
              <ChevronDownIcon className="inline" width={16} height={16} />
            </>
          )}
        </div>
      </div>
    </>
  );
}
