'use client';

import { IVideo } from 'src/interfaces';
import classNames from 'classnames';
import Link from 'next/link';
import { ArrowRightIcon } from '@heroicons/react/24/solid';
import { VideoGridItem } from './grid-item';

interface Props {
  videos: (IVideo | any)[];
  span?: {
    xs?: number;
    md?: number;
    sm?: number;
    lg?: number;
    xl?: number;
  };
  className?: string;
  showMorePath?: string;
}

export default function VideoGrid({
  videos,
  className = '',
  span = {
    xs: 2,
    sm: 2,
    md: 3,
    lg: 4,
    xl: 5
  },
  showMorePath = '/default-path'
}: Props) {
  if (!videos.length) return null;

  return (
    <div
      className={classNames(
        `grid grid-cols-${span.xs} gap-3 md:grid-cols-${span.md} lg:grid-cols-${span.lg} xl:grid-cols-${span.xl} 3xl:grid-cols-8 4xl:grid-cols-12`,
        className
      )}
    >
      {videos.map((video) => {
        if (video._id === 'show-more') {
          return (
            <Link href={showMorePath} key={video._id} passHref>
              <div className="flex items-center justify-center border-2 rounded-lg cursor-pointer text-lg font-bold text-orange-500 h-full w-full" key={video.name}>
                Show more
                {' '}
                <ArrowRightIcon className="w-8 h-8 ms-2 stroke-2" />
              </div>
            </Link>
          );
        }
        return (
          <VideoGridItem
            dataSource={video}
            key={video._id}
          />
        );
      })}
    </div>
  );
}
