'use client';

import Image from 'next/image';
import Link from 'next/link';
import { IVideo } from 'src/interfaces';
import { PencilIcon } from '@heroicons/react/24/solid';
import { formatDuration } from '@lib/date';
import { capitalizeFirstLetter } from '@lib/string';
import { toast } from 'react-toastify';
import {
  EyeIcon,
  HandThumbUpIcon
} from '@heroicons/react/24/outline';
import { formatNumber } from '@lib/utils';
import VideoTrashAction from './actions/trash';

interface Props {
  video: IVideo;
}

export function UploadedVideo({ video }: Props) {
  const [thumbnail] = video.thumbnails || ['/images/placeholder.png'];
  // Calculate like percentage
  const totalVotes = (video?.stats?.likes || 0) + (video?.stats?.dislikes || 0);
  const likePercentage = totalVotes > 0 ? Math.round((video.stats.likes / totalVotes) * 100) : 0;
  return (
    <div className="rounded-lg cursor-pointer border-2 p-2 group relative">
      {/* Video Image */}
      <div className="relative pt-[69%] w-full">
        <Link
          href={`/videos/${video.slug || video._id}`}
          onClick={(event) => {
            if (!video.verified) {
              event.preventDefault();
              toast.error('Please wait for the admin approval');
            }
          }}
        >
          <Image
            src={thumbnail || '/images/placeholder.png'}
            alt=""
            fill
            priority
            className="img-cover rounded-md"
          />
        </Link>
        {video.isHD && (
        <div className="absolute top-2 right-2 bg-red-gradient rounded z-1">
          <div className="text-sm font-bold p-1 text-white">HD</div>
        </div>
        )}
        <div className="absolute bottom-2 left-2 bg-black rounded z-1">
          <div className="text-xs font-bold p-1 text-white">
            {capitalizeFirstLetter(video.convertStatus)}
          </div>
        </div>
        <div className="absolute bottom-2 right-2 bg-black rounded z-1">
          <div className="text-xs font-bold p-1 text-white">
            {formatDuration(video.duration)}
          </div>
        </div>
      </div>

      <div className="text-sm font-semibold my-2">
        <Link
          href={`/videos/${video.slug || video._id}`}
          onClick={(event) => {
            if (!video.verified) {
              event.preventDefault();
              toast.error('Please wait for the admin approval');
            }
          }}
        >
          {video.title}
        </Link>
      </div>

      <div className="flex items-center text-xs text-gray-600 justify-between mb-2">
        {/* {publicSettings.hideLikes && ( */}
        <span className="flex items-center space-x-1" style={{ color: 'var(--text-color)' }}>
          <HandThumbUpIcon
            className="w-4 h-4 text-gray-600"
            style={{ color: 'var(--icon-color)' }}
          />
          <span>
            {likePercentage}
            %
          </span>
        </span>
        {/* )} */}
        <span className="flex items-center space-x-1">
          <EyeIcon
            className="w-4 h-4 text-gray-600"
            style={{ color: 'var(--icon-color)' }}
          />
          <span>{formatNumber(video.stats.views || 0)}</span>
        </span>
      </div>
      <div className="flex justify-between items-center mt-2">
        <Link href={`/account/my-upload/update/${video.slug || video._id}`}>
          <PencilIcon
            className="cursor-pointer text-normal"
            width={16}
            height={16}
          />
        </Link>
        <VideoTrashAction video={video} />
      </div>
    </div>
  );
}
