import { videoService } from '@services/video.service';
import { cookies } from 'next/headers';
import VideoGrid from './video-grid';

export default async function TrendingVideos() {
  const cookieStore = await cookies();
  const token = cookieStore.get('token');
  const { error, data } = await videoService.search(
    {
      limit: 9,
      sortBy: 'trending'
    },
    {
      Authorization: token?.value || ''
    }
  );

  if (error) return null;
  if (!data!.data.length) return null;
  const videos = data!.data;
  const showMoreVideo = {
    _id: 'show-more',
    slug: 'show-more'
  };

  return (
    <VideoGrid videos={[...videos, showMoreVideo]} showMorePath="/videos/trending" />
  );
}
