import { videoService } from '@services/video.service';
import { cookies } from 'next/headers';
import VideoGrid from './video-grid';

export default async function TopRatedVideos() {
  const cookieStore = await cookies();
  const token = cookieStore.get('token');
  const { error, data } = await videoService.search(
    {
      limit: 9,
      sortBy: 'rating'
    },
    {
      Authorization: token?.value || ''
    }
  );
  if (error) return null;
  if (!data!.data.length) return null;

  const showMoreVideo = {
    _id: 'show-more',
    slug: 'show-more'
  };

  return (
    <VideoGrid videos={[...data!.data, showMoreVideo]} showMorePath="/videos/rating" />
  );
}
