'use client';

import { Listbox } from '@headlessui/react';
import classNames from 'classnames';
import { usePathname, useRouter, useSearchParams } from 'next/navigation';
import { useMemo } from 'react';
import { ChevronDownIcon } from '@heroicons/react/24/solid';

export function VideoSorter() {
  const searchParams = useSearchParams();
  const pathname = usePathname();
  const router = useRouter();

  // translate this
  const sorter = useMemo(
    () => [
      {
        key: 'new',
        title: 'Date'
      },
      {
        key: 'trending',
        title: 'Trending'
      },
      {
        key: 'rating',
        title: 'Top Rated'
      }
    ],
    []
  );

  const handleChange = (sortBy: string) => {
    const params = new URLSearchParams(searchParams);
    params.set('sortBy', sortBy);
    router.push(`${pathname}?${params.toString()}`);
  };

  const activeKey = useMemo(
    () => sorter.find(
      (option) => option.key === (searchParams.get('sortBy') || 'new')
    ),
    [searchParams, sorter]
  );

  return (
    <div className="relative text-sm z-40">
      <Listbox onChange={handleChange}>
        <Listbox.Button className="flex items-center border-2 border-md rounded p-1.5">
          Sort by
          {' '}
          {activeKey?.title || 'Date'}
          {' '}
          <ChevronDownIcon width={14} height={14} />
        </Listbox.Button>
        <Listbox.Options className="absolute top-full right-0 cursor-pointer z-1 mt-2 w-56 origin-top-right divide-y divide-gray-100 rounded-md bg-white shadow-lg ring-1 ring-black/5 focus:outline-none transform opacity-100 scale-100">
          {sorter.map((option) => (
            <Listbox.Option
              key={option.key}
              className={classNames(
                'text-gray-900 group flex w-full items-center rounded-md px-2 py-2.5 text-sm hover:text-primary',
                { ' text-primary': searchParams.get('sortBy') === option.key }
              )}
              value={option.key}
            >
              {option.title}
            </Listbox.Option>
          ))}
        </Listbox.Options>
      </Listbox>
    </div>
  );
}
