import { videoService } from '@services/video.service';
import { VideoSearch } from 'src/interfaces';
import VideoGrid from './video-grid';

interface Props extends Partial<VideoSearch> {
  span?: {
    xs?: number;
    md?: number;
    sm?: number;
    lg?: number;
    xl?: number;
  },
  className?: string;
}

export default async function RelatedVideo({
  limit = 10, className = '', span = {
    xs: 2, sm: 2, md: 3, lg: 4, xl: 5
  }, ...params
}: Props) {
  const { error, data } = await videoService.search({ limit, ...params });
  if (error) return null;
  if (!data!.data.length) return null;

  return (
    <VideoGrid videos={data!.data} className={className} span={span} />
  );
}
