import { videoService } from '@services/video.service';
import { cookies } from 'next/headers';
import VideoGrid from './video-grid';

export default async function Newvideos() {
  const cookieStore = await cookies();
  const token = cookieStore.get('token');
  const { error, data } = await videoService.search(
    {
      limit: 9,
      sortBy: 'new'
    },
    {
      Authorization: token?.value || ''
    }
  );
  if (error) return null;
  if (!data!.data.length) return null;

  const showMorePornStars = {
    _id: 'show-more',
    slug: 'show-more'
  };

  return (
    <VideoGrid videos={[...data!.data, showMorePornStars]} showMorePath="/videos/new" />
  );
}
