/* eslint-disable react/button-has-type */

'use client';

import { formatDuration } from '@lib/date';
import Link from 'next/link';
import { IVideo, IVideoStats } from 'src/interfaces';
import { Transition } from '@headlessui/react';
import { EyeIcon } from '@heroicons/react/24/outline';
import { formatNumber } from '@lib/utils';
import { useMemo } from 'react';

import VideoGridItemThumbnail from './grid-item-thumbnail';

interface Props {
  dataSource: IVideo & { stats: IVideoStats };
}

export function VideoGridItem({ dataSource }: Props) {
  const randomViews = useMemo(() => {
    const random = Math.random() * 9 + 1;
    return `${random.toFixed(1)}k`;
  }, []);

  return (
    <Transition
      appear={false}
      show
      enter="transition-opacity duration-1000"
      enterFrom="opacity-0"
      enterTo="opacity-100"
      leave="transition-opacity duration-500"
      leaveFrom="opacity-100"
      leaveTo="opacity-0"
    >
      <div className="rounded-lg cursor-pointer border-2 flex flex-col h-full group">
        <div className="relative pt-[69%] w-full">
          <Link href={`/videos/${dataSource?.slug || dataSource?._id}`}>
            <VideoGridItemThumbnail thumbnails={dataSource?.thumbnails} />
          </Link>
          {dataSource?.isHD && (
            <div className="absolute top-2 right-2 bg-red-gradient rounded z-1">
              <div className="text-sm font-bold p-1 text-white">HD</div>
            </div>
          )}
          <div className="absolute bottom-2 right-2 bg-black rounded z-1">
            <div className="text-xs font-bold p-1 text-white">
              {formatDuration(dataSource?.duration)}
            </div>
          </div>
        </div>
        <div className="p-2 flex flex-col justify-between flex-grow">
          <h3 className="text-sm font-bold text-gray-1000 truncate overflow-hidden max-h-6 whitespace-nowrap">
            <Link href={`/videos/${dataSource?.slug || dataSource?._id}`}>
              {dataSource?.title}
            </Link>
          </h3>
          <div className="flex justify-between items-center mt-1">
            <span className="flex items-center text-xs space-x-1">
              <EyeIcon className="w-4 h-4 text-gray-600" style={{ color: 'var(--icon-color)' }} />
              <span>
                {randomViews}
              </span>
            </span>
          </div>
        </div>
      </div>
    </Transition>
  );
}
