'use client';

import Image from 'next/image';
import { useMainThemeLayout } from 'src/providers/main-layout.provider';

export default function VideoGridItemThumbnail({ thumbnails = [] }: any) {
  const [thumbnail] = thumbnails;
  const { publicSettings } = useMainThemeLayout();
  return (
    <Image
      src={
        thumbnail
        || publicSettings.defaultThumbnailImage
        || '/images/placeholder.png'
      }
      alt=""
      fill
      priority
      loading="eager"
      className="img-cover rounded-md"
      // placeholder='blur'
      placeholder="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mM89R8AApkBy17XrZoAAAAASUVORK5CYII="
    />
  );
}
