'use client';

// refactor server action

import { TrashIcon } from '@heroicons/react/24/solid';
import { getResponseError } from '@lib/utils';
import { videoService } from '@services/video.service';
import { useRouter } from 'next/navigation';
import { toast } from 'react-toastify';
import { IVideo } from 'src/interfaces';

interface Props {
  video: IVideo;
}

export default function VideoTrashAction({ video }: Props) {
  const router = useRouter();
  const handleClick = async () => {
    try {
      if (!window.confirm('Are you sure to delete this video!')) return;

      await videoService.remove(video._id);
      router.refresh();
    } catch (e) {
      const error = await e;
      toast.error(getResponseError(error));
    }
  };
  return <TrashIcon onClick={handleClick} className="cursor-pointer text-normal" width={16} height={16} />;
}
