'use server';

import { fetcher } from '@lib/server';
import { IVideo } from 'src/interfaces';

export async function like(prevState: IVideo, action: 'like' | 'dislike') {
  if (action === 'like') {
    if (prevState.isLiked) {
      await fetcher('/reactions', 'DELETE', {
        objectType: 'video',
        action: 'like',
        objectId: prevState._id
      });
      return {
        ...prevState,
        isLiked: false,
        stats: {
          ...prevState.stats,
          likes: Math.max(prevState.stats.likes - 1, 0)
        }
      } as IVideo;
    }
    await Promise.all([
      fetcher('/reactions', 'POST', {
        objectType: 'video',
        action: 'like',
        objectId: prevState._id
      }),
      prevState.isDisLiked && fetcher('/reactions', 'DELETE', {
        objectType: 'video',
        action: 'dislike',
        objectId: prevState._id
      })
    ]);
    return {
      ...prevState,
      isLiked: true,
      isDisLiked: false,
      stats: {
        ...prevState.stats,
        likes: Math.max(prevState.stats.likes + 1, 0),
        dislikes: prevState.isDisLiked ? Math.max(prevState.stats.dislikes - 1, 0) : prevState.stats.dislikes
      }
    } as IVideo;
  }

  if (action === 'dislike') {
    if (prevState.isDisLiked) {
      await fetcher('/reactions', 'DELETE', {
        objectType: 'video',
        action: 'dislike',
        objectId: prevState._id
      });
      return {
        ...prevState,
        isDisLiked: false,
        stats: {
          ...prevState.stats,
          dislikes: Math.max(prevState.stats.dislikes - 1, 0)
        }
      } as IVideo;
    }
    await Promise.all([
      fetcher('/reactions', 'POST', {
        objectType: 'video',
        action: 'dislike',
        objectId: prevState._id
      }),
      prevState.isLiked && fetcher('/reactions', 'DELETE', {
        objectType: 'video',
        action: 'like',
        objectId: prevState._id
      })
    ]);
    return {
      ...prevState,
      isDisLiked: true,
      isLiked: false,
      stats: {
        ...prevState.stats,
        dislikes: Math.max(prevState.stats.dislikes + 1, 0),
        likes: prevState.isLiked ? Math.max(prevState.stats.likes - 1, 0) : prevState.stats.likes
      }
    } as IVideo;
  }
  return prevState;
}
