'use server';

import { fetcher } from '@lib/server';
import { revalidateTag } from 'next/cache';
// import { revalidateTag } from 'next/cache';
import { IVideo } from 'src/interfaces';

export async function bookmark(prevState: IVideo) {
  await Promise.all([
    fetcher('/reactions', prevState.isBookmarked ? 'DELETE' : 'POST', {
      objectType: 'video',
      action: 'bookmark',
      objectId: prevState._id
    })
  ]);
  revalidateTag('video');
  // revalidateTag('reaction');
  return {
    ...prevState,
    isBookmarked: !prevState.isBookmarked,
    stats: {
      favourites: prevState.isBookmarked ? prevState.stats.favourites - 1 : prevState.stats.favourites + 1
    }
  } as IVideo;
}
