import classNames from 'classnames';
import { ReactNode } from 'react';

import s from './form-item.module.scss';

interface Props {
  children: ReactNode;
  classnames?: string;
}

export function FormItem({ children, classnames }: Props) {
  return (
    <div className={classNames('mb-5 relative', s['form-item'], classnames)}>
      {children}
    </div>
  );
}

FormItem.Error = function Error({ children, classnames = '' }: Props) {
  return (
    <p className={classNames(s.form_error, classnames)}>
      {children}
    </p>
  );
};

FormItem.Label = function Label({
  children,
  classnames,
  required = false
}: Props & { required?: boolean }) {
  return (
    // eslint-disable-next-line jsx-a11y/label-has-associated-control
    <label
      className={classNames(
        'block text-sm font-medium leading-8',
        { [s.required]: required },
        classnames
      )}
      htmlFor=""
    >
      {children}
    </label>
  );
};
