'use client';

import classNames from 'classnames';
import { useState } from 'react';
import TailwindDatepickerReact from 'tailwind-datepicker-react';
import { IDatePickerProps } from 'tailwind-datepicker-react/types/Components/DatePicker';

interface Props extends Omit<IDatePickerProps, 'show' | 'setShow'> {
  classnames?: string;
}

export function DatePicker({ classnames = '', ...props }: Props) {
  const [show, setShow] = useState(false);

  return (
    <div className={classNames('relative', classnames)}>
      <TailwindDatepickerReact
        {...props}
        options={{
          todayBtn: false,
          clearBtn: false,
          datepickerClassNames: 'top-auto bottom-12',
          theme: {
            selected: 'bg-primary',
            background: '',
            todayBtn: 'dark:bg-primary',
            clearBtn: '',
            icons: '',
            text: '',
            disabledText: 'dark:text-gray-500',
            input: 'bg-input color-black block w-full rounded-md p-2.5 pl-10 focus:ring-2 focus:ring-inset focus:border-transparent focus:ring-orange-500 outline-none  sm:text-sm sm:leading-6 border border-gray-300 dark:border-zinc-700',
            inputIcon: ''
          },
          ...props.options
        }}
        show={show}
        setShow={setShow}
      />
    </div>
  );
}
