'use client';

import { getBase64 } from '@lib/upload';
import Image from 'next/image';
import { ChangeEvent, useState } from 'react';
import { toast } from 'react-toastify';

interface Props {
  onChange: (f: File) => void;
  avatar: string;
}

export function AvatarUpload({ avatar, onChange }: Props) {
  const [file, setFile] = useState<string>();

  // eslint-disable-next-line consistent-return
  const handleChange = (e: ChangeEvent<HTMLInputElement>) => {
    if (e.target.files && e.target.files[0]) {
      const isMaxSize = e.target.files[0].size / 1024 / 1024 > (Number(process.env.MAX_SIZE_IMAGE || 5));
      if (isMaxSize) {
        toast.error(`Avatar must be smaller than ${process.env.MAX_SIZE_IMAGE || 5}MB!`);
        return false;
      }
      getBase64(e.target.files[0], (url) => setFile(url));
      onChange(e.target.files[0]);
    }

    // onChange(e.target.files[0]);
  };

  return (
    <div className="flex space-x-3 cursor-pointer relative w-full rounded-md py-2.5 bg-input ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:border-transparent focus:ring-orange-500 p-5 outline-none sm:text-sm sm:leading-6 border dark:border-none">
      <Image
        className="w-24 h-24 rounded-md"
        src={file || avatar || '/images/no-avatar.png'}
        alt=""
        width={100}
        height={100}
      />
      <input
        type="file"
        className="w-full h-full absolute top-0 left-0 z-1 opacity-0 cursor-pointer"
        accept="image/*"
        onChange={handleChange}
      />
      <div className="flex flex-col gap-2 items-start justify-center">
        <button
          type="button"
          className="inline-flex items-center border py-1 px-5 rounded-md border-primary text-primary"
        >
          Edit
        </button>
        <p className="text-sm">
          Size limit
          :
          {' '}
          {process.env.MAX_SIZE_IMAGE || 5}
          MB
        </p>
      </div>
    </div>
  );
}
