import classNames from 'classnames';
import Link from 'next/link';

interface Props {
  wrap?: boolean;
  className?: string;
  tags: {
    label: string;
    href: string;
    key: string;
  }[];
}

export function Tags({ tags, wrap = false, className = '' }: Props) {
  return (
    <div className={classNames('flex items-center overflow-auto gap-1.5', className, wrap ? 'flex-wrap' : 'flex-nowrap')}>
      {tags.length > 0
        && tags.map((tag) => (
          <Link key={tag.key} href={tag.href} className="text-sm cursor-pointer text-black dark:text-white hover:text-primary hover:border-primary font-semibold whitespace-nowrap items-center justify-center px-1 py-1.5 rounded-md border-2 border-solid">
            {tag.label}
          </Link>
        ))}
    </div>
  );
}
