'use client';

import { Tab } from '@headlessui/react';
import classNames from 'classnames';
import { ReactNode, useState } from 'react';

interface Props {
  tabs: {
    title: ReactNode;
    children: ReactNode;
    id: string;
  }[];
}

export function Tabs({ tabs }: Props) {
  const [selectedIndex, setSelectedIndex] = useState(0);

  return (
    <div className="w-full">
      <Tab.Group selectedIndex={selectedIndex} onChange={setSelectedIndex}>
        <Tab.List className="flex space-x-2 overflow-auto">
          {tabs.map((tab) => (
            <Tab
              key={`tab-${tab.id}`}
              className={({ selected }) => classNames(
                'py-2.5 text-sm font-medium leading-5 capitalize focus-visible:outline-0 focus-visible:outline-none',
                selected ? 'text-primary ' : 'text-gray-500 hover:text-primary'
              )}
            >
              {tab.title}
            </Tab>
          ))}
        </Tab.List>
        <Tab.Panels className="mt-2">
          {tabs.map((tab) => (
            <Tab.Panel key={tab.id}>{tab.children}</Tab.Panel>
          ))}
        </Tab.Panels>
      </Tab.Group>
    </div>
  );
}
