'use client';

import Table from 'rc-table';
import { Pagination } from './pagination';

interface Props<T = any> {
  columns: any;
  total: number;
  pageSize: number;
  page: number;
  query: any;
  data: T;
}

export default function Table2({
  columns,
  query,
  data,
  total,
  pageSize,
  page
}: Props) {
  return (
    <div>
      <Table
        columns={columns}
        data={data}
        scroll={{ x: 1200 }}
        className="bg-white text-black"
        rowClassName="text-sm text-center text capitalize"
      />
      <div className="flex items-center">
        <div className="text-sm">
          {data.length}
          {' '}
          of
          {total}
          {' '}
          items
        </div>
        <div className="ml-auto">
          <Pagination
            total={total}
            pageSize={pageSize}
            query={query}
            page={page}
          />
        </div>
      </div>
    </div>
  );
}
