'use client';

import { usePathname, useRouter } from 'next/navigation';
import { useCallback } from 'react';
import ReactPaginate from 'react-paginate';

interface Props {
  total?: number;
  pageSize?: number;
  query?: any;
  page?: number;
}

export function Pagination({
  total = 0,
  pageSize = 10,
  query = {},
  page = 1
}: Props) {
  const pathname = usePathname();
  const router = useRouter();
  const pages = Math.ceil(total / pageSize);

  const handleChange = useCallback((event:{selected: number}) => {
    const current = event.selected + 1;

    if (current === page) return;

    const params = new URLSearchParams(query);
    params.set('page', current.toString());
    router.push(`${pathname}?${params.toString()}`);
  }, [page, pathname, query, router]);

  if (total <= pageSize) return null;

  return (
    <div className="text-center my-5">
      <ReactPaginate
        breakLabel="..."
        nextLabel=">"
        onPageChange={handleChange}
        pageRangeDisplayed={5}
        pageCount={pages}
        previousLabel="<"
        renderOnZeroPageCount={null}
        // initialPage={page}
        forcePage={page - 1}
        containerClassName="flex items-center justify-center px-1"
        pageClassName="px-2"
        nextClassName="px-1 "
        nextLinkClassName="text-normal hover:text-primary"
        previousClassName="px-1"
        previousLinkClassName="text-normal hover:text-primary"
        activeClassName="px-2 roundedy"
        pageLinkClassName="text-normal"
        activeLinkClassName="text-primary"
      />
    </div>
  );
}
