'use client';

import { Dialog } from '@headlessui/react';
import { XMarkIcon } from '@heroicons/react/24/outline';
import classNames from 'classnames';
import { ReactNode } from 'react';

interface Props {
  visible: boolean;
  onClose: () => void;
  children: ReactNode;
  className?: string;
}

export function Modal({
  visible, onClose, children, className
}: Props) {
  return (
    <Dialog as="div" className="relative z-[99]" open={visible} onClose={onClose}>
      <div className="fixed inset-0 backdrop-blur-sm bg-black/80" aria-hidden="true" />
      <div className="fixed inset-0 z-10 w-screen overflow-y-auto">
        <div className="flex min-h-full items-center justify-center text-center sm:items-center">
          <Dialog.Panel
            className={classNames(
              'relative transform rounded-lg text-left shadow-md transition-all sm:my-8 bg-gradient max-w-[95%]',
              className
            )}
          >
            <div aria-hidden className="absolute top-0 right-2 p-3 cursor-pointer hover:text-primary transition-all z-10" onClick={onClose}><XMarkIcon width={25} height={25} /></div>
            {children}
          </Dialog.Panel>
        </div>
      </div>
    </Dialog>
  );
}
