import classNames from 'classnames';
import React from 'react';

interface IProps {
  spinning?: boolean;
  fullScreen?: boolean;
  center?: boolean;
}

function Loader({ spinning = false, fullScreen = false, center = false }: IProps) {
  return (
    <div
      className={classNames('loader flex items-center justify-center w-full h-full mt-5', {
        hidden: !spinning,
        'fixed bg-white dark:bg-black top-0 left-0': fullScreen,
        'absolute top-0': center
      })}
    >
      <div className="flex justify-center items-center space-x-1 text-sm text-gray-700 dark:text-white">
        <svg
          fill="none"
          className="w-10 h-10 animate-spin"
          viewBox="0 0 32 32"
          xmlns="http://www.w3.org/2000/svg"
          width={32}
          height={32}
        >
          <path
            clipRule="evenodd"
            d="M15.165 8.53a.5.5 0 01-.404.58A7 7 0 1023 16a.5.5 0 011 0 8 8 0 11-9.416-7.874.5.5 0 01.58.404z"
            fill="currentColor"
            fillRule="evenodd"
          />
        </svg>
        <div>
          Loading
          ...
        </div>
      </div>
    </div>
  );
}

export default Loader;
