import classNames from 'classnames';
import { ReactNode } from 'react';

interface Props {
  title: ReactNode;
  icon?: ReactNode;
  extra?: ReactNode;
  divider?: boolean;
}

export function Heading({
  icon, title, extra, divider
}: Props) {
  return (
    <div className={classNames('flex items-center w-ful', { 'border-bottom-2 pb-2 mb-4': divider })}>
      <div className="space-x-2 flex flex-auto items-center">
        {icon && <div className="p-3 bg-primary text-white text-lg rounded-md">{icon}</div>}
        <div className="text-xl font-bold">{title}</div>
      </div>
      {extra && <div className="ml-auto">{extra}</div>}
    </div>
  );
}
