'use client';

import { ReactNode, useRef } from 'react';
import { useOnClickOutside } from 'usehooks-ts';
import classNames from 'classnames';

interface Props {
  children: ReactNode;
  visible: boolean;
  className?: string;
  onClose: () => void;
}

export default function Drawer({
  children,
  visible,
  className,
  onClose
}: Props) {
  const ref = useRef<HTMLDivElement>(null);
  const handleClickOutside = () => {
    if (visible) onClose();
  };

  useOnClickOutside(ref, handleClickOutside);

  return (
    <>
      <div
        ref={ref}
        className={classNames('fixed top-0 left-0 h-screen text-left bg-white dark:bg-black transition-all overflow-hidden shadow-md', className)}
        style={{ width: visible ? 300 : 0, zIndex: 52, backgroundColor: 'var(--background-color)' }}
      >
        {children}
      </div>
      <div className={visible ? 'top-0 h-screen w-screen fixed left-0 bg-black hidden max-md:block dark:bg-opacity-40 bg-opacity-10' : 'hidden'} style={{ zIndex: 51 }} />
    </>
  );
}
