import classNames from 'classnames';
import { ReactNode } from 'react';

interface Props {
  children: ReactNode;
  type?: 'default' | 'primary' | 'link';
  htmlType?: 'submit' | 'button' | 'reset' | undefined;
  className?: string;
  hidden?: boolean;
  onClick?: (e: any) => void;
}

export function Button({
  children,
  type = 'default',
  htmlType = 'button',
  className = '',
  hidden = false,
  ...props
}: Props) {
  return (
    <button
      hidden={hidden}
      className={classNames(
        'rounded-md inline-flex items-center px-3 py-1.5 text-sm font-semibold leading-6 shadow-sm focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-orange-600',
        {
          'bg-primary text-white ': type === 'primary',
          'bg-neutral-100 dark:bg-neutral-700 text-black dark:text-white': type === 'default',
          'btn-link': type === 'link'
        },
        className
      )}
      // eslint-disable-next-line react/button-has-type
      type={htmlType}
      {...props}
    >
      {children}
    </button>
  );
}
