'use client';

import { FormEvent, ReactNode } from 'react';
import { useFormStatus } from 'react-dom';
import { useProfile } from 'src/providers/profile.provider';
import { useMainThemeLayout } from 'src/providers/main-layout.provider';

interface ButtonProps {
  children: ReactNode;
  className?: string;
}

function Button({ className, children }: ButtonProps) {
  const { pending } = useFormStatus();
  const { loggedIn } = useProfile();
  const { login } = useMainThemeLayout();

  const handleClick = (e: FormEvent<HTMLButtonElement>) => {
    if (pending) e.preventDefault();

    if (!loggedIn) {
      e.preventDefault();
      login();
    }
  };

  return (
    <button
      onClick={handleClick}
      type="submit"
      className={className}
      disabled={pending}
      aria-disabled={pending}
    >
      {children}
    </button>
  );
}

export async function PornstarReaction() {
  return (
    <div className="ml-auto space-x-3">
      <Button className="hidden rounded-md bg-black px-3 py-1.5 text-sm font-semibold leading-6 text-white shadow-sm hover:bg-orange-500 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-orange-600">
        Message
      </Button>
    </div>
  );
}
