'use client';

import Image from 'next/image';
import Link from 'next/link';
import { IPornstar } from 'src/interfaces';
import { useMainThemeLayout } from 'src/providers/main-layout.provider';
import { AiFillPlaySquare } from 'react-icons/ai';
import { formatNumber } from '@lib/utils';
import s from './grid-item.module.scss';

interface Props {
  dataSource: IPornstar;
}

export function PornstarGridItem({ dataSource }: Props) {
  const { publicSettings } = useMainThemeLayout();

  return (
    <Link href={`/pornstars/${dataSource.username || dataSource._id}`}>
      <div className="rounded-lg cursor-pointer border-2">
        <div className="relative pt-[125%] w-full rounded-t-md overflow-hidden">
          <Image style={{ objectFit: 'cover' }} src={dataSource.avatarUrl || publicSettings.defaultThumbnailImage || '/images/placeholder.png'} alt="" fill priority />
        </div>
        <div className="p-4 text-sm text-center text-black dark:text-white">
          <p className="text-ellipsis overflow-hidden whitespace-nowrap text-base capitalize">{dataSource.name}</p>
          <div className="flex justify-between content-center">
            <span className="flex items-center content-center">
              <AiFillPlaySquare size={25} className={s['primary-icon']} />
              &nbsp;
              {formatNumber(dataSource.stats.videos)}
            </span>
          </div>
        </div>
      </div>
    </Link>
  );
}
