/* eslint-disable @next/next/no-img-element */

'use client';

import classNames from 'classnames';
import { useMainThemeLayout } from 'src/providers/main-layout.provider';

interface Props {
  className?: string;
}

export default function SiteLogo({ className }: Props) {
  const {
    publicSettings: { logoUrl }
  } = useMainThemeLayout();

  return (
    <img
      className={classNames('max-w-[200px] max-h-[60px]', className)}
      src={logoUrl || '/images/logo-white.png'}
      alt="logo"
    />
  );
}
