import classnames from 'classnames';
import React from 'react';
import Loader from '@components/ui/base/loader';

interface IProps {
  loading?: boolean;
  className?: string;
  inner?: boolean;
  children: any;
}

export default function Page({
  className, children, loading = false, inner = false
}: IProps) {
  return (
    <div
      className={classnames('', className, {
        'px-2.5 py-10 md:py-5 w-full sm:!px-10': inner
      })}
    >
      {loading ? <Loader spinning /> : ''}
      {children}
    </div>
  );
}
