import { ReactNode } from 'react';
import classNames from 'classnames';
import s from './page.module.scss';

interface Props {
  title: ReactNode;
  textClassName?: string;
}
export function PageHeader({ title, textClassName = '' }: Props) {
  const decodedTitle = typeof title === 'string' ? decodeURIComponent(title) : title;
  return (
    <h1
      className={s['heading-main']}
    >
      <span className={classNames('text-lg md:text-2xl', textClassName)}>{decodedTitle}</span>
    </h1>
  );
}
